// HookSTCExe.cpp : Defines the entry point for the console application.
//
// The Loader app that hooks SetThreadContext
// The idea is that we create the target process in suspended mode and inject our DLL
// Our DLL hooks the SetThreadContext API
// We resume the process
// When any of the threads in the target process calls SetThreadContext(), our 
// function will get called ;)
//

#include "stdafx.h"
#include <windows.h>
#include "ApiHooks.h"


int main(int argc, char* argv[])
{

	STARTUPINFO si ;
	PROCESS_INFORMATION pi ;

	ZeroMemory (&si, sizeof (STARTUPINFO)) ;
	si.cb = sizeof (STARTUPINFO) ;

	OutputDebugString ("Creating Process Suspended...") ;

	if (CreateProcess (NULL, 
				   " DRxClear.exe",
				   NULL,
				   NULL,
				   TRUE,
				   CREATE_SUSPENDED,
				   NULL,
				   NULL,
				   &si,
				   &pi) != 0)			// Create the process

	{
		OutputDebugString ("Process creation sucessfull...") ;

		HANDLE hProcess = pi.hProcess ;

		hEstablishApiHooks(NULL, "HookSTCDLL.dll", hProcess, 3000);		// Hook it

		ResumeThread (pi.hThread) ;
	}
	else
	{
		OutputDebugString ("Process creation failed...") ;

	}

	return 0;
}
