// HookSTCDLL.cpp : Defines the entry point for the DLL application.
//
// Source code for the injected DLL
// We just make use of APIHooks.
// Tested on Win98SE with ApiHooks 5.6
//

#include "stdafx.h"
#include <windows.h>
#include "ApiHooks.h"

UINT WINAPI NewSTC(HANDLE hThread, CONTEXT *ctx) 
{

	CONTEXT c ;
	//
	// The thread would've already been suspended in the calling program
	//
	c.ContextFlags = CONTEXT_DEBUG_REGISTERS ;
	GetThreadContext (hThread, &c) ;			// Get the ThreadContext Registers

	ctx->ContextFlags = CONTEXT_DEBUG_REGISTERS ;
	ctx->Dr0 = c.Dr0 ;
	ctx->Dr1 = c.Dr1 ;
	ctx->Dr2 = c.Dr2 ;
	ctx->Dr3 = c.Dr3 ;
	ctx->Dr7 = c.Dr7 ;							// Set the original ones 

	return SetThreadContext (hThread, ctx) ;	// Call the original SetThreadContext
}

#define NHOOKS 3
//__declspec(dllexport) API_HOOK ApiHookChain[NHOOKS] = {
__EXPORT API_HOOK ApiHookChain[NHOOKS] = {
  {NULL,NULL,0},  //empty hook will be changed to dynamic if LoadLibrary(Ex)A will be called in Win9x in order to hook newly loaded module
  {"KERNEL32.DLL", "SetThreadContext" , HOOK_BY_NAME | HOOK_BY_ADDRESS | HOOK_SPECIAL, ALL_MODULES, NULL, NewSTC},
  {HOOKS_END}
};

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{

	if(ul_reason_for_call == DLL_PROCESS_ATTACH)
		OutputDebugString ("Process Attached...") ;

	else if(ul_reason_for_call == DLL_PROCESS_DETACH)
		OutputDebugString ("Process Detached...") ;

    return TRUE;
}

