// DRxClearCons.cpp : Defines the entry point for the console application.
// 
// Illustrates how to clear the DRx registers using SEH
// This now-a-days seems to in-vogue. Also, you achieve a lot of platform independence
// No more ring-0 stuff, let the OS do the dirty job ;)
//
// Tested on Win98SE
//

#include "stdafx.h"
#include <windows.h>
#include <stdio.h>

HANDLE hMainThread = NULL;
HANDLE hDupHandle = NULL ;
BOOL bFlag = FALSE ;
char szBuf[4096];

DWORD WINAPI ThreadFunc( LPVOID lpParam ) 
{ 
    char szMsg[80];

	// Create an Divide-by-zero Exception
	__try
	{
		OutputDebugString ("Within __try for generating divide-by-zero interrupt") ;
		int m = 0 ;
		int j = 1/m ;
	}
	__except (GetExceptionCode() == EXCEPTION_INT_DIVIDE_BY_ZERO)		// Handle it here
	{
		OutputDebugString ("Within divide-by-zero interrupt handler") ;

		OutputDebugString ("Created Thread and waiting for STC") ;
		
		CONTEXT cxt ;

		OutputDebugString ("Inside the Exception Handler for divide-by-zero") ;

		SuspendThread (hDupHandle) ;							// Suspend the thread other wise STC is unreliable

		OutputDebugString ("Suspended the Thread") ;

		cxt.ContextFlags = CONTEXT_DEBUG_REGISTERS ;
		cxt.Dr0 = 0 ;
		cxt.Dr1 = 0 ;
		cxt.Dr2 = 0 ;
		cxt.Dr3 = 0 ;
		cxt.Dr7 = 0x155 ;										// Bye Bye DRx registers

		if (SetThreadContext (hDupHandle, &cxt) == 0)			// call SetThreadContext
		{
			printf ("GetLastError() = %d\n", GetLastError()) ;
		}

		OutputDebugString ("Set the Context") ;

		bFlag = TRUE ;											// Toggle the flag so that the original thread is released

		ResumeThread(hDupHandle) ;								// Resume the original thread

		OutputDebugString ("Resumed the Thread") ;

		CloseHandle (hDupHandle) ;								// Close the handle
	}

    return 0; 
} 

int main(int argc, char* argv[])
{
	__asm
	{
		int 3 ;			// This is so that we can break in SoftICE to set some BPMs
	}					// Since this is a console app, SoftICE Loader will not break :(

	hMainThread = GetCurrentThread() ;					// Get the Handle to the current thread

    DuplicateHandle(GetCurrentProcess(), hMainThread,
        GetCurrentProcess(), &hDupHandle , 0,
        TRUE,											// Since this is a pseudo handle, 
        DUPLICATE_SAME_ACCESS);							// duplicate it to get a valid handle


	DWORD dwID ;

	CreateThread (NULL,
				  0,
				  ThreadFunc,
				  NULL,
				  0,
				  &dwID) ;								// Create a Thread. Callback is ThreadFunc

	while (bFlag == FALSE) ;							// Wait for the thread to do the DRx stuff :)

	printf ("%x: szBuf\n", szBuf) ;						// Get the address of szBuf to set BPM on

	strcpy (szBuf, "hello") ;							// Write something into buf. So we can set BPMB xxxxxxxx w in SICE

	MessageBox (NULL, "hi", "caption", MB_OK) ;			// Put up a MessageBox just for debugging

	return 0;
}
